//
//  Handling_Interruptions_While_Playing_AudioViewController.m
//  Handling Interruptions While Playing Audio
//
//  Created by Vandad Nahavandipoor on 15/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Handling_Interruptions_While_Playing_AudioViewController.h"

@implementation Handling_Interruptions_While_Playing_AudioViewController

@synthesize audioPlayer;

- (void)didReceiveMemoryWarning{
  [super didReceiveMemoryWarning];
}

- (void)audioPlayerBeginInterruption:(AVAudioPlayer *)player{
  
  /* Sesja audio została przerwana. W tym miejscu odtwarzacz będzie zatrzymany. */
  
}

- (void)audioPlayerEndInterruption:(AVAudioPlayer *)player 
                         withFlags:(NSUInteger)flags{
  
  if (flags == AVAudioSessionInterruptionFlags_ShouldResume &&
      player != nil){
    [player play];
  }
  
}

- (void)audioPlayerDidFinishPlaying:(AVAudioPlayer *)player 
                       successfully:(BOOL)flag{
  
  NSLog(@"Zakończono odtwarzanie utworu.");
  
  /* Parametr [flag] informuje, czy odtwarzanie zakończyło się powodzeniem. */
  
  if ([player isEqual:self.audioPlayer]){
    self.audioPlayer = nil;
  } else {
    /* To nie jest nasz odtwarzacz treści audio! */
  }
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  dispatch_queue_t dispatchQueue = 
  dispatch_get_global_queue(DISPATCH_QUEUE_PRIORITY_DEFAULT, 0);
  
  dispatch_async(dispatchQueue, ^(void) {
    NSBundle *mainBundle = [NSBundle mainBundle];
    
    NSString *filePath = [mainBundle pathForResource:@"MySong"
                                              ofType:@"mp3"];
    
    NSData   *fileData = [NSData dataWithContentsOfFile:filePath];
    
    NSError  *error = nil;
    
    /* Utworzenie odtwarzacza treści audio. */  
    self.audioPlayer = [[AVAudioPlayer alloc] initWithData:fileData
                                                     error:&error];
    
    /* Czy jest dostępny egzemplarz AVAudioPlayer? */
    if (self.audioPlayer != nil){
      /* Zdefiniowanie delegata i rozpoczęcie odtwarzania treści audio. */
      self.audioPlayer.delegate = self;
      if ([self.audioPlayer prepareToPlay]&&
          [self.audioPlayer play]){
        /* Udało się rozpocząć odtwarzanie. */
      } else {
        /* Nie udało się rozpocząć odtwarzania. */
      }
    } else {
      /* Nie udało się utworzyć egzemplarza AVAudioPlayer. */
    }
  });
  
}

- (void) viewDidUnload{
  [super viewDidUnload];
  
  if([self.audioPlayer isPlaying]){
    [self.audioPlayer stop];
  }
  self.audioPlayer = nil;
  
}

- (BOOL)shouldAutorotateToInterfaceOrientation
:(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
